********************************************************************************
********************************************************************************
* Date: November 2025
** Do: Code to reproduce Chapter 7 of World Inequality Report 2026
*** Author: Ricardo Gómez-Carrera
	* 1. Figure 7.1. A more progressive tax system is needed in order to reduce political capture by the very rich
	* 2. Figure 7.2. The super-rich pay proportionately less than others
	* 3. Figure 7.3. The rise of global multi-millionaire wealth
	* 4. Figure 7.4. Coordinated minimum taxation can safeguard progressivity at the top
	* 5. Figure 7.5. Taxing only a few people can provide large revenues to decrease inequality
	* 6. Figure 7.6. Large regional wealth tax revenue potential
	* 7. Figure 7.7. Large inequality of opportunity across regions
	* 8. Figure 7.8. Coordination between countries strengthens the feasibility to reduce tax evasion and avoidance
	* 9. Figure 7.9. Billionaires are changing country of residence at a continuous pace
	*10. Figure Box 7.1. Explore the golbal wealth tax simulator

********************************************************************************
********************************************************************************

/*
For information on how to use the widcode and the World Inequality Database, visit:
	*1. https://wid.world/codes-dictionary/
	*2. https://github.com/world-inequality-database/wid-stata-tool
	*3. https://github.com/world-inequality-database/wid-r-tool
	*4. https://wid.world/document/distributional-national-accounts-dina-guidelines-2025-methods-and-concepts-used-in-the-world-inequality-database/
	
	For other data inputs visit:
	*1. https://github.com/world-inequality-database/wid-world/tree/master/data-input
	
*/


**# Figure 7.1. A more progressive tax system is needed in order to reduce political capture by the very rich
* ---------------------------------------------------------------------------- *
* ---------------------------------------------------------------------------- * 
/*
Data from Cagé (2024)
Figures 5 and 7 in Cagé (2024)

Paper
https://wid.world/document/political-inequality-wid-world-working-paper-2023-22/

Data provided by Julia Cagé
*/

*** South Korea
forvalues y=2014(1)2021 {
	import excel "$raw/Withhold_Tax_Data.xlsx", sheet("`y'") cellrange(A5:G116) clear
	drop if _n<=2
	destring A E F G, replace 
	rename A inc_perc_percentile 
	rename B inc_perc_detail
	rename C inc_perc_nb_people
	rename D inc_perc_total_Income 
	rename E pol_don_nb_people 
	rename F pol_don_total_amount 	
	rename G tax_credit 
	gen pol_don_average_amount =pol_don_total_amount/pol_don_nb_people
	
	gen cat=.
	replace cat=13 if inc_perc_percentile==.001
	replace cat=10 if inc_perc_percentile>=.01 & inc_perc_percentile<=.1 /* .01 .02 .03 .04 .05 .06 .07 .08 .09 .1 */
	replace cat=9 if inc_perc_percentile>=.11 & inc_perc_percentile<=.2 /* .11 .12 .13 .14 .15 .16 .17 .18 .19 .2 */
	replace cat=8 if inc_perc_percentile>=.21 & inc_perc_percentile<=.3	/* .21 .22 .23 .24 .25 .26 .27 .28 .29 .3 */
	replace cat=7 if inc_perc_percentile>=.31 & inc_perc_percentile<=.4	/* .31 .32 .33 .34 .35 .36 .37 .38 .39 .4 */
	replace cat=6 if inc_perc_percentile>=.41 & inc_perc_percentile<=.5	/* .41 .42 .43 .44 .45 .46 .47 .48 .49 .5 */
	replace cat=5 if inc_perc_percentile>=.51 & inc_perc_percentile<=.6	/* .51 .52 .53 .54 .55 .5600000000000001 .57 .58 .59 .6 */ 
	replace cat=4 if inc_perc_percentile>=.61 & inc_perc_percentile<=.7	/* .61 .62 .63 .64 .65 .66 .67 .68 .6899999999999999 .7 */
	replace cat=3 if inc_perc_percentile>=.71 & inc_perc_percentile<=.8	/*.71 .72 .73 .74 .75 .76 .77 .78 .79 .8 */
	replace cat=2 if inc_perc_percentile>=.81 & inc_perc_percentile<=.9	/*.8100000000000001 .82 .83 .84 .85 .86 .87 .88 .89 .9*/
	replace cat=1 if inc_perc_percentile>=.91 & inc_perc_percentile<=1 	/* .91 .92 .93 .9399999999999999 .95 .96 .97 .98 .99 1 */
	order cat 
	
	bysort cat : egen dec_pol_don_total_amount=sum(pol_don_total_amount)
	
	gen year =`y'
	order year 
	
	drop if cat==.
	duplicates drop cat, force 
	keep year cat dec_pol_don_total_amount
	
	tempfile with`y'_dec
	save `with`y'_dec', replace 
		}
clear 
forvalues y=2014(1)2021 {		
	append using `with`y'_dec'
	}	
bysort year : egen sum_pol_don=sum(dec_pol_don_total_amount)
	gen share_pol_don=(dec_pol_don_total_amount/sum_pol_don)*100		

keep if cat>=1 & cat<=10
drop if year==2014
bysort cat : egen mean_pol_don_dec_SK=mean(share_pol_don)
duplicates drop cat, force 
keep cat mean_pol_don_dec_SK
rename cat cat2
tempfile SK
save `SK', replace


*** France
import excel "$raw/C_stat_des_by_pct.xlsx", sheet("C2_cat_rev") firstrow clear
drop if an==.
destring don_partis_politique don_partis_politique_dum don_partis_politique_mean don_partis_politique_mean_notnul tx_don_partis_politique_rev part_don_partis_politique, replace
gen cat=.
replace cat=1 if cat_rev=="D1"
replace cat=2 if cat_rev=="D2"
replace cat=3 if cat_rev=="D3"
replace cat=4 if cat_rev=="D4"
replace cat=5 if cat_rev=="D5"
replace cat=6 if cat_rev=="D6"
replace cat=7 if cat_rev=="D7"
replace cat=8 if cat_rev=="D8"
replace cat=9 if cat_rev=="D9"
replace cat=10 if cat_rev=="P90-99"
replace cat=11 if cat_rev=="P99-P99.99"
replace cat=12 if cat_rev=="P99.9-P99.99"
replace cat=13 if cat_rev=="P99.99-100"
rename don_partis_politique_mean_notnul don_pp_mean_notnul
destring don_coluche dons_ir_notredame  don_autres nb_individu, replace
gen dons_charities=don_coluche + dons_ir_notredame +  don_autres
gen dons_charities_mean=dons_charities/nb_individu
destring don_coluche_dum dons_ir_notredame_dum don_autres_dum, replace
gen don_charities_dum=don_coluche_dum + dons_ir_notredame_dum + don_autres_dum
gen don_charities_mean_notnull=dons_charities/don_charities_dum
drop if an<2013
foreach var of varlist don_partis_politique_mean don_pp_mean_notnul red_don_pol_66_dum red_don_pol_66_mean_notnull ///
don_coluche_mean don_coluche_mean_notnull don_autres_mean don_autres_mean_notnull ///
dons_charities dons_charities_mean don_charities_mean_notnull {
	destring `var', replace
	bysort cat : egen av_`var'=mean(`var')
	}
foreach var of varlist don_coluche don_partis_politique don_autres ///
dons_charities {	
	destring `var', replace
	}	
preserve
	keep if cat>=10
	collapse (sum) don_coluche don_partis_politique don_autres dons_charities, by(an)
	gen cat=14
	gen cat_rev="D10"
	tempfile D10
	save `D10', replace
restore
append using `D10'
preserve
	import excel "$raw/A_stat_des_all.xlsx", sheet("A1_all") firstrow clear
	drop if an<2013
	drop if an==.
	destring don_coluche dons_ir_notredame  don_autres, replace
	gen dons_charities=don_coluche + dons_ir_notredame +  don_autres
	keep an don_coluche don_partis_politique don_autres dons_charities
	destring don_coluche don_partis_politique don_autres dons_charities, replace
	foreach var of varlist don_coluche don_partis_politique don_autres dons_charities {
		rename `var' tot_`var'
		}
	tempfile total
	save `total', replace
restore
merge m:1 an using `total'
	drop _merge
foreach var of varlist don_coluche don_partis_politique don_autres dons_charities {	
	gen sh_`var'=(`var'/tot_`var')*100
	}
gen cat2=.
replace cat2=1 if cat_rev=="D1"
replace cat2=2 if cat_rev=="D2"
replace cat2=3 if cat_rev=="D3"
replace cat2=4 if cat_rev=="D4"
replace cat2=5 if cat_rev=="D5"
replace cat2=6 if cat_rev=="D6"
replace cat2=7 if cat_rev=="D7"
replace cat2=8 if cat_rev=="D8"
replace cat2=9 if cat_rev=="D9"
replace cat2=10 if cat_rev=="D10"
replace cat2=11 if cat_rev=="P99-P99.99"
replace cat2=12 if cat_rev=="P99.9-P99.99"
replace cat2=13 if cat_rev=="P99.99-100"
foreach var of varlist sh_don_partis_politique sh_don_coluche sh_don_autres sh_dons_charities {
	bysort cat2 : egen av_`var'=mean(`var')
	}	
foreach var of varlist sh_don_partis_politique sh_don_coluche sh_don_autres sh_dons_charities {
	bysort an cat2 : egen av_`var'_an=mean(`var')
	}	
order an cat2 av_sh_don_partis_politique	
duplicates drop cat2, force 
keep cat2 av_sh_don_partis_politique
keep if cat2<=10	
	
merge 1:1 cat2 using `SK', nogen
	
twoway (connected av_sh_don_partis_politique cat, sort) ///
	(connected mean_pol_don_dec_SK cat, sort msymbol(triangle) lpattern(dash)), ///
	xlabel(1 "P0-10" 2 "P10-20" 3 "P20-30" 4 "P30-40" 5 "P40-50" 6 "P50-60" 7 "P60-70" 8 "P70-80" 9 "P80-90" 10 "P90-100", labsize(small) angle(45)) ///
	xtitle(Income decile, size(small)) ///
	ylabel(0(10)60, labsize(small) angle(horizontal) format(%15.0fc)) ///
	ytitle("Percentage of total political donations", size(small)) ///
	legend(row(1) size(small) order(1 "France" 2 "South Korea") position(6)) ///
	graphregion(color(white))

***USA		
import excel "$raw/Duquette Top Donor Time Series.xlsx", sheet("Figs 1 and 3") firstrow clear	

replace Givingsharetop001donors=Givingsharetop001donors*100
twoway (connected Givingsharetop001donors Year, sort ), ///
	xtitle("") xlabel(1960(4)2012) ///
	ytitle("Donation share of the top 0.01%") ylabel(0(4)20, angle(horizontal)) ///
	graphregion(color(white))


**# Figure 7.2. The super-rich pay proportionately less than others
* ---------------------------------------------------------------------------- *
* ---------------------------------------------------------------------------- * 
/*
Data from Artola et al. (2022), Bozio et al. (2024), Bozio et al. (2020), Bruil et al. (2024), Palomo et al. (2025), Saez and Zucman (2019), and Zucman (2024)

United States 
-Table TC8 (and Figure 5) in Saez and Zucman (2019), data provided by Gabriel Zucman
-Paper: https://gabriel-zucman.eu/files/SaezZucman2019BPEA.pdf
-Replication package: https://gabriel-zucman.eu/files/SaezZucman2019BPEAData.xlsx

France
-Figure 2 in Zucman (2024), data provided by Gabriel Zucman
-Report: https://gabriel-zucman.eu/files/report-g20.pdf
-Sources: Bozio et al. (2020) and Bozio et al. (2024)

The Netherlands
-Figure 2 in Zucman (2024), data provided by Gabriel Zucman
-Report: https://gabriel-zucman.eu/files/report-g20.pdf
-Sources: Bruil et al. (2024), Figure 7
https://www.cpb.nl/system/files/cpbmedia/omnidownload/CPB-Discussion-Paper-436-Inequality-and-Redistribution-in-the-Netherlands.pdf

Brazil
-Figure 10 in Palomo et al. (2025), data provided by Theo Palomo
-Paper:https://gabriel-zucman.eu/files/PalomoEtal2025.pdf

Spain
-Source: Artola et al. (2022), data provided by Clara Martínez-Toledano
-Paper: https://www.esade.edu/ecpol/wp-content/uploads/2022/06/AAFF_ESP_EsadeEcPol_Brief27_DesigualdadRenta_final_final.pdf


*/



**# Figure 7.3. The rise of global multi-millionaire wealth
* ---------------------------------------------------------------------------- *
* ---------------------------------------------------------------------------- * 
clear 
insobs 1 
g use_widcode="$use_widcode"

if use_widcode=="YES"{
	wid, ind(ahweal  shweal  mnweal  mnninc  npopul mhweal  npopul ) age(999 992) pop(j) area( WO) year(  $year_output) clear
	ren (variable country percentile) (widcode iso p)
	drop age pop
	g currency=""
	keep if inlist(widcode,"ahweal992j","shweal992j","mnweal999i","mnninc999i","npopul992i","mhweal999i","npopul999i")
}
else{
use if inlist(widcode,"ahweal992j","shweal992j","mnweal999i","mnninc999i","npopul992i","mhweal999i","npopul999i") /// 
 & (iso == "WO" ) using $wid2024, clear
}	

keep if inlist(widcode,"mhweal999i","mnninc999i","npopul999i","mnweal999i","npopul992i")  | /// 
	(inlist(widcode,"shweal992j","ahweal992j") & p=="p99.999p100"  )


drop currency iso p
	
greshape wide value, i(year) j(widcode)	string
renvars value*, predrop(5)
keep if year>=1995

g pop_t0_001=npopul992i*(.001/100)
g wealth_t0_001=ahweal992j*pop_t0_001
g sh_t0_001=(wealth_t0_001)/mnninc999i
tsset year
tsline sh_t0_001
sort year
keep year sh_t0_001

label var sh_t0_001 "Wealth of the global top 0.001%, as a fraction of global income"
export excel using "$outputs/WIR_2026_Chapter7.xlsx", sheet("data-F7.3", replace) firstrow(varl) sheetmod cell(A1) 
putexcel set "$outputs/WIR_2026_Chapter7.xlsx", modify sheet("data-F7.3")
putexcel (B2:B99), nformat(percent)




**# Figure 7.4. Coordinated minimum taxation can safeguard progressivity at the top
* ---------------------------------------------------------------------------- *
* ---------------------------------------------------------------------------- * 
/*
-Figure 7 in Zucman (2024), data provided by Gabriel Zucman
-Report: https://gabriel-zucman.eu/files/report-g20.pdf
*/


**# Figure 7., 7.6, and Box 7.1
* ---------------------------------------------------------------------------- *
* ---------------------------------------------------------------------------- * 
/*
-Data obtained from the Global Wealth Tax Simulator
-https://wid.world/world-wealth-tax-simulator/
*/



**# Figure 7.7. Large inequality of opportunity across regions
* ---------------------------------------------------------------------------- *
* ---------------------------------------------------------------------------- * 
/*
Data from Bharti et al. (2025)
Figure 8a  in Bharti et al. (2025)

Paper
https://wid.world/document/human-capital-unequal-opportunities-and-productivity-convergence-a-global-historical-perspective-1800-2100-world-inequality-lab-working-paper-2025-15/

Replication package
https://wid.world/document/data-file-to-human-capital-unequal-opportunities-and-productivity-convergence-a-global-historical-perspective-1800-2100-appendix-to-wil-working-paper-2025-15/
*/


**# Figure 7.8. Coordination between countries strengthens the feasibility to reduce tax evasion and avoidance
* ---------------------------------------------------------------------------- *
* ---------------------------------------------------------------------------- * 
/*
-Figure 1.4 in Alstadsæter et al. (2023), data provided by Quentin Parrinello
-Source: EU Tax Observatory
-Report: https://www.taxobservatory.eu/www-site/uploads/2023/10/global_tax_evasion_report_24.pdf
*/


**# Figure 7.9. Billionaires are changing country of residence at a continuous pace
* ---------------------------------------------------------------------------- *
* ---------------------------------------------------------------------------- * 
/*
-Figure 8 in Zucman (2024), data provided by Gabriel Zucman
-Report: https://gabriel-zucman.eu/files/report-g20.pdf
*/