Attribute VB_Name = "Module2"
Sub CreateWorkbook_With_AllTables()
    Dim wbSrc As Workbook
    Dim wbOut As Workbook
    Dim wsSrc As Worksheet
    Dim wsOut As Worksheet
    Dim countryName As String
    Dim shName As String

    Set wbSrc = ThisWorkbook
    Set wbOut = Workbooks.Add  ' <-- NEW workbook containing only tables

    Application.ScreenUpdating = False
    Application.DisplayAlerts = False

    For Each wsSrc In wbSrc.Sheets
        
        countryName = wsSrc.Name
        shName = countryName & "_Table"

        ' ---- Create new sheet for this table ----
        Set wsOut = wbOut.Sheets.Add
        wsOut.Name = shName
        
        ' ==== PARAMETERS ====
        Dim headerWidth As Double: headerWidth = 9
        Dim fontSize As Double: fontSize = 11

        ' ==== COLORS ====
        Const LatinGreen_R As Integer = 44
        Const LatinGreen_G As Integer = 160
        Const LatinGreen_B As Integer = 44
        Const NAORed_R As Integer = 227
        Const NAORed_G As Integer = 0
        Const NAORed_B As Integer = 11

        ' ==== COLUMN WIDTHS ====
        wsOut.Columns("A").ColumnWidth = 7.8
        wsOut.Columns("B:E").ColumnWidth = headerWidth

        ' ==== MAIN HEADERS ====
        wsOut.Range("B1:C1").Merge
        wsOut.Range("D1:E1").Merge
        wsOut.Range("B1").Value = "Income"
        wsOut.Range("D1").Value = "Wealth"
        wsOut.Range("B1:C1").Interior.Color = RGB(LatinGreen_R, LatinGreen_G, LatinGreen_B)
        wsOut.Range("D1:E1").Interior.Color = RGB(LatinGreen_R, LatinGreen_G, LatinGreen_B)
        wsOut.Range("B1:E1").Font.Color = vbWhite
        wsOut.Range("B1:E1").Font.Bold = True
        wsOut.Range("B1:E1").HorizontalAlignment = xlCenter
        wsOut.Range("B1:E1").VerticalAlignment = xlCenter

        ' ==== STACKED SUBHEADERS ====
        wsOut.Range("B2").Value = "Avg." & vbCrLf & "Income" & vbCrLf & "(PPP )"
        wsOut.Range("C2").Value = "Share" & vbCrLf & "of" & vbCrLf & "total (%)"
        wsOut.Range("D2").Value = "Avg." & vbCrLf & "Wealth" & vbCrLf & "(PPP )"
        wsOut.Range("E2").Value = "Share" & vbCrLf & "of" & vbCrLf & "total (%)"
        wsOut.Range("A2:E2").Font.Bold = True
        wsOut.Range("A2:E2").HorizontalAlignment = xlCenter
        wsOut.Range("A2:E2").VerticalAlignment = xlCenter
        wsOut.Range("A2:E2").WrapText = True
        wsOut.Rows("2:2").RowHeight = 45
        wsOut.Range("B2:E2").Interior.Color = RGB(NAORed_R, NAORed_G, NAORed_B)
        wsOut.Range("B2:E2").Font.Color = vbWhite

        ' ==== DATA ROWS ====
        Dim labels As Variant, rowIndex As Long
        labels = Array("Full" & vbCrLf & "pop.", "Bottom" & vbCrLf & "50%", _
                       "Middle" & vbCrLf & "40%", "Top" & vbCrLf & "10%", _
                       "Top" & vbCrLf & "1%")

        For rowIndex = 0 To 4
            Dim rowOffset As Long
            rowOffset = 3 + rowIndex

            wsOut.Range("A" & rowIndex + 3).Value = labels(rowIndex)

            ' === Pull from source sheet ===
            wsOut.Range("B" & rowIndex + 3).Value = wsSrc.Range("F" & rowOffset).Value
            wsOut.Range("C" & rowIndex + 3).Value = wsSrc.Range("G" & rowOffset).Value
            wsOut.Range("D" & rowIndex + 3).Value = wsSrc.Range("H" & rowOffset).Value
            wsOut.Range("E" & rowIndex + 3).Value = wsSrc.Range("I" & rowOffset).Value

            wsOut.Range("B" & rowIndex + 3).NumberFormat = "#,##0"
            wsOut.Range("C" & rowIndex + 3).NumberFormat = "0.0%"
            wsOut.Range("D" & rowIndex + 3).NumberFormat = "#,##0"
            wsOut.Range("E" & rowIndex + 3).NumberFormat = "0.0%"
        Next rowIndex

        ' ==== YEAR ROW ====
        wsOut.Range("A8:C8").Merge
        wsOut.Range("A8").Value = "Year"
        wsOut.Range("A8:C8").Interior.Color = RGB(LatinGreen_R, LatinGreen_G, LatinGreen_B)
        wsOut.Range("A8:C8").Font.Color = vbWhite
        wsOut.Range("A8:C8").Font.Bold = True
        wsOut.Range("A8:C8").HorizontalAlignment = xlCenter
        wsOut.Range("A8:C8").VerticalAlignment = xlCenter

        wsOut.Range("D8").Value = "2014"
        wsOut.Range("E8").Value = "2024"
        wsOut.Range("D8:E8").Interior.Color = RGB(NAORed_R, NAORed_G, NAORed_B)
        wsOut.Range("D8:E8").Font.Color = vbWhite
        wsOut.Range("D8:E8").Font.Bold = True
        wsOut.Range("D8:E8").HorizontalAlignment = xlCenter
        wsOut.Range("D8:E8").VerticalAlignment = xlCenter

        ' ==== SUMMARY ROWS ====
        wsOut.Range("A9:C9").Merge
        wsOut.Range("A9").Value = "Top 10% to Bot. 50%" & vbCrLf & "Income gap"
        wsOut.Range("A9:C9").WrapText = True
        wsOut.Rows("9:9").RowHeight = 32

        wsOut.Range("D9").Value = wsSrc.Range("K2").Value
        wsOut.Range("E9").Value = wsSrc.Range("K3").Value
        wsOut.Range("D9:E9").NumberFormat = "0.0"

        wsOut.Range("A10:C10").Merge
        wsOut.Range("A10").Value = "Female labor share"

        wsOut.Range("D10").Value = wsSrc.Range("J2").Value
        wsOut.Range("E10").Value = wsSrc.Range("J3").Value
        wsOut.Range("D10:E10").NumberFormat = "0.0%"

        ' ==== BORDERS ====
        With wsOut.Range("A1:E10").Borders
            .LineStyle = xlContinuous
            .Weight = xlThin
        End With

        ' ==== FONT & ALIGNMENT ====
        With wsOut.Range("A1:E10")
            .HorizontalAlignment = xlCenter
            .VerticalAlignment = xlCenter
            .WrapText = True
            .Font.Name = "Calibri"
            .Font.Size = fontSize
            .Font.Bold = True
        End With
        wsOut.Range("B3:E7").Font.Bold = False
        wsOut.Range("D9:E10").Font.Bold = False

    Next wsSrc

    ' Delete the three default blank sheets Excel adds to new workbooks
    Dim s As Worksheet
    For Each s In wbOut.Sheets
        If s.UsedRange.Address = "$A$1" And s.Range("A1").Value = "" Then s.Delete
    Next s

    Application.DisplayAlerts = True
    Application.ScreenUpdating = True
    
    MsgBox "New Workbook created with all tables.", vbInformation

End Sub


