Attribute VB_Name = "Module1"
Sub MakeAllCountryChartsBiggerLines_NewWorkbook()

    Dim wbSrc As Workbook
    Dim wbOut As Workbook
    Dim wsData As Worksheet
    Dim wsChart As Worksheet
    Dim countryName As String
    Dim chartSheetName As String
    Dim lastRow As Long

    ' Create new output workbook
    Set wbSrc = ThisWorkbook
    Set wbOut = Workbooks.Add

    Application.ScreenUpdating = False
    Application.DisplayAlerts = False

    ' Remove default blank sheets from new workbook
    Dim s As Worksheet
    For Each s In wbOut.Worksheets
        If wbOut.Worksheets.Count > 1 Then s.Delete
    Next s

    ' ==== CONSTANTS ====
    Dim stepSize As Long: stepSize = 20
    Dim labelOffsetYears As Double: labelOffsetYears = 5
    Dim topColor As Long: topColor = RGB(227, 0, 11)
    Dim bottomColor As Long: bottomColor = RGB(44, 160, 44)
    Dim chartWidth As Double: chartWidth = 400
    Dim chartHeight As Double: chartHeight = 320

    For Each wsData In wbSrc.Worksheets
        
        If Right(wsData.Name, 5) = "_DATA" Then
        
            ' ==== Sheet names ====
            countryName = Replace(wsData.Name, "_DATA", "")
            chartSheetName = countryName & "_figure1"

            ' ==== Create chart sheet in NEW WORKBOOK ====
            Set wsChart = wbOut.Sheets.Add
            wsChart.Name = chartSheetName
            wsChart.Cells.Interior.Color = RGB(255, 255, 255)
            ActiveWindow.DisplayGridlines = False

            ' ==== Read data from source workbook ====
            lastRow = wsData.Cells(wsData.Rows.Count, "A").End(xlUp).Row

            Dim yearRange As Variant, topRange As Variant, bottomRange As Variant

            yearRange = wsData.Range("A2:A" & lastRow).Value
            topRange = wsData.Range("B2:B" & lastRow).Value
            bottomRange = wsData.Range("C2:C" & lastRow).Value

            ' ==== Axis limits ====
            Dim firstYear As Long, lastYearVal As Long
            firstYear = wsData.Range("A2").Value
            lastYearVal = wsData.Range("A" & lastRow).Value

            If firstYear < 1980 Then firstYear = 1900

            Dim ymaxRaw As Double, ymax As Double, ymin As Double
            ymaxRaw = WorksheetFunction.Max(WorksheetFunction.Max(topRange), WorksheetFunction.Max(bottomRange))
            ymax = ymaxRaw * 1.1
            ymax = 10 * WorksheetFunction.RoundUp(ymax / 10, 0)
            ymin = 0

            Dim top10_start As Double, bottom50_start As Double
            top10_start = topRange(1, 1)
            bottom50_start = bottomRange(1, 1)

            ' ==== Create chart ====
            Dim chObj As ChartObject, ch As Chart
            Set chObj = wsChart.ChartObjects.Add(Left:=100, Top:=50, Width:=chartWidth, Height:=chartHeight)
            Set ch = chObj.Chart

            With ch
                .ChartType = xlXYScatterLinesNoMarkers
                .HasLegend = False

                .ChartArea.Format.Fill.ForeColor.RGB = RGB(255, 255, 255)
                .PlotArea.Format.Fill.ForeColor.RGB = RGB(255, 255, 255)
                .ChartArea.Border.LineStyle = xlNone
                .PlotArea.Border.LineStyle = xlNone

                ' ==== Top 10% ====
                .SeriesCollection.NewSeries
                With .SeriesCollection(1)
                    .Name = "Top 10%"
                    .XValues = yearRange
                    .Values = topRange
                    .Format.Line.ForeColor.RGB = topColor
                    .Format.Line.Weight = 3#
                End With

                ' ==== Bottom 50% ====
                .SeriesCollection.NewSeries
                With .SeriesCollection(2)
                    .Name = "Bottom 50%"
                    .XValues = yearRange
                    .Values = bottomRange
                    .Format.Line.ForeColor.RGB = bottomColor
                    .Format.Line.Weight = 3#
                End With

                ' ==== X axis ====
                With .Axes(xlCategory)
                    .MinimumScale = firstYear
                    .MaximumScale = lastYearVal
                    .MajorUnit = stepSize
                    .HasMajorGridlines = True
                    .MajorGridlines.Format.Line.ForeColor.RGB = RGB(220, 220, 220)
                    .TickLabels.Orientation = 45
                    .TickLabels.Font.Name = "Garamond"
                    .TickLabels.Font.Size = 13
                    .TickLabels.Font.Bold = True
                End With

                ' ==== Y axis ====
                With .Axes(xlValue)
                    .MinimumScale = ymin
                    .MaximumScale = ymax
                    .MajorUnit = 10
                    .HasMajorGridlines = True
                    .MajorGridlines.Format.Line.ForeColor.RGB = RGB(220, 220, 220)
                    .TickLabels.NumberFormat = "0""%"""
                    .TickLabels.Font.Name = "Garamond"
                    .TickLabels.Font.Size = 13
                    .TickLabels.Font.Bold = True
                End With

                ' ==== Y axis title ====
                .Axes(xlValue).HasTitle = True
                With .Axes(xlValue).AxisTitle
                    .Caption = "Income share (% total)"
                    .Format.TextFrame2.TextRange.Font.Name = "Garamond"
                    .Format.TextFrame2.TextRange.Font.Size = 15
                    .Format.TextFrame2.TextRange.Font.Bold = True
                End With

                ' ==== Annotations (same as original) ====
                Dim labelX As Double: labelX = firstYear + labelOffsetYears

                Dim xCoord As Double: xCoord = (labelX - firstYear) / Application.Max(0.00001, (lastYearVal - firstYear))
                Dim yCoordTop As Double: yCoordTop = 1 - ((top10_start - ymin) / (ymax - ymin))
                Dim yCoordBottom As Double: yCoordBottom = 1 - ((bottom50_start - ymin) / (ymax - ymin))

                Dim plotLeft As Double, plotTop As Double, plotW As Double, plotH As Double
                plotLeft = .PlotArea.InsideLeft
                plotTop = .PlotArea.InsideTop
                plotW = .PlotArea.InsideWidth
                plotH = .PlotArea.InsideHeight

                Dim px As Double, pyTop As Double, pyBottom As Double
                px = plotLeft + xCoord * plotW
                pyTop = plotTop + yCoordTop * plotH + 10
                pyBottom = plotTop + yCoordBottom * plotH - 35

                ' Top 10% label
                With .Shapes.AddTextbox(msoTextOrientationHorizontal, px, pyTop, 80, 26)
                    .TextFrame2.TextRange.Text = "Top 10%"
                    .TextFrame2.TextRange.Font.Bold = True
                    .TextFrame2.TextRange.Font.Fill.ForeColor.RGB = topColor
                    .TextFrame2.TextRange.Font.Name = "Garamond"
                    .TextFrame2.TextRange.Font.Size = 18
                    .Fill.Solid
                    .Fill.ForeColor.RGB = RGB(255, 255, 255)
                    .Line.Visible = msoTrue
                    .Line.ForeColor.RGB = topColor
                    .Line.Weight = 1.25
                End With

                ' Bottom 50% label
                With .Shapes.AddTextbox(msoTextOrientationHorizontal, px, pyBottom, 109, 24)
                    .TextFrame2.TextRange.Text = "Bottom 50%"
                    .TextFrame2.TextRange.Font.Bold = True
                    .TextFrame2.TextRange.Font.Fill.ForeColor.RGB = bottomColor
                    .TextFrame2.TextRange.Font.Name = "Garamond"
                    .TextFrame2.TextRange.Font.Size = 18
                    .Fill.Solid
                    .Fill.ForeColor.RGB = RGB(255, 255, 255)
                    .Line.Visible = msoTrue
                    .Line.ForeColor.RGB = bottomColor
                    .Line.Weight = 1.25
                End With

            End With

            Debug.Print "? Created chart for " & countryName

        End If
    Next wsData

    Application.DisplayAlerts = True
    Application.ScreenUpdating = True

    MsgBox "? All country charts added to NEW WORKBOOK!", vbInformation

End Sub

